<?php
require_once 'config.php';
require_once 'header.php';
?>

<div class="hero-section text-center">
  <div class="container">
    <h1 class="display-4 mb-4">Empowering African Talent</h1>
    <p class="lead">Connect with skilled freelancers across the continent</p>
    <a href="register.php" class="btn btn-primary btn-lg mt-3">
      Get Started <i class="fas fa-arrow-right"></i>
    </a>
  </div>
</div>

<div class="row">
    <?php
    $result = $conn->query("SELECT * FROM gigs WHERE status='open' ORDER BY created_at DESC LIMIT 6");
    if ($result->num_rows > 0):
        while($gig = $result->fetch_assoc()):
    ?>
    <div class="col-md-4 mb-4">
  <div class="card gig-card h-100">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-start mb-3">
        <h5 class="card-title"><?= htmlspecialchars($gig['title']) ?></h5>
        <span class="badge gig-badge"><?= $gig['category'] ?></span>
      </div>
      <p class="card-text text-muted"><?= substr(htmlspecialchars($gig['description']), 0, 100) ?>...</p>
      <div class="d-flex justify-content-between align-items-center">
        <h5 class="text-success">$<?= $gig['budget'] ?></h5>
        <a href="gig-details.php?id=<?= $gig['id'] ?>" class="btn btn-sm btn-primary">
          View Details
        </a>
      </div>
    </div>
    <div class="card-footer bg-transparent">
      <small class="text-muted">Posted <?= date('M j', strtotime($gig['created_at'])) ?></small>
    </div>
  </div>
</div>
    <?php
        endwhile;
    else:
    ?>
    <div class="col-12">
        <div class="alert alert-info">No open gigs yet. Be the first to post!</div>
    </div>
    <?php endif; ?>
</div>

<?php require_once 'footer.php'; ?>